/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_compare ( alb, aeb, agb, aleb, aneb, ageb, dataa, datab ) ;

parameter lpm_type = "lpm_compare" ; 
parameter lpm_width = 1 ; 
parameter lpm_rep = "UNSIGNED" ;
parameter polar_alb   = "NORMAL" ; 
parameter polar_aeb   = "NORMAL" ; 
parameter polar_agb   = "NORMAL" ; 
parameter polar_aleb  = "NORMAL" ; 
parameter polar_aneb  = "NORMAL" ; 
parameter polar_ageb  = "NORMAL" ; 
parameter polar_dataa = "NORMAL" ; 
parameter polar_datab = "NORMAL" ;

  input  [lpm_width-1:0] dataa, datab ;
  output alb, aeb, agb, aleb, aneb, ageb ;

  wire   [lpm_width-1:0] dataa, datab ;
  reg    [lpm_width-2:0] tmp_a, tmp_b ;
  reg    tmp_alb, tmp_aeb, tmp_agb ;
  reg    tmp_aleb, tmp_aneb, tmp_ageb ;
  reg    [lpm_width-1:0] pdataa , pdatab ;
  integer i, dataa_int, datab_int;

  always @(dataa or datab)
    begin
	  pdataa <= #1 (polar_dataa == "INVERT")?~dataa:dataa ;
	  pdatab <= #1 (polar_datab == "INVERT")?~datab:datab ;
    end

  always @(pdataa or pdatab)
  begin
	  // lpm_rep is optional and default to SIGNED.
      if ((lpm_rep == "SIGNED") 
		|| (lpm_rep == "")) // SIGNED
      begin
        // convert to negative integer
        if(pdataa[lpm_width-1] == 1)
        begin
            for(i = 0; i < lpm_width - 1; i = i + 1)
                tmp_a[i] = pdataa[i] ^ 1;
            dataa_int = (tmp_a + 1) * (-1) ;
        end
        else dataa_int = pdataa;

        // convert to negative integer
        if(pdatab[lpm_width-1] == 1)
        begin
            for(i = 0; i < lpm_width - 1; i = i + 1)
                tmp_b[i] = pdatab[i] ^ 1;
            datab_int = (tmp_b + 1) * (-1);
        end
        else datab_int = pdatab;
	end
    else if (lpm_rep == "UNSIGNED") // SIGNED
    begin
		dataa_int = pdataa ;
		datab_int = pdatab ;
	end
  end

  always @(pdataa or pdatab)
  begin
	  tmp_alb = #1 0 ;
	  tmp_aeb = #1 0 ;
	  tmp_agb = #1 0 ;
	  tmp_aleb = #1 0 ;
	  tmp_aneb = #1 0 ;
	  tmp_ageb = #1 0 ;

	  if(dataa_int < datab_int)
		  tmp_alb = 1 ;
	  if(dataa_int == datab_int)
		  tmp_aeb = 1 ;
	  if(dataa_int > datab_int)
		  tmp_agb = 1 ;
	  if(dataa_int <= datab_int)
		  tmp_aleb = 1 ;
	  if(dataa_int !=  datab_int)
		  tmp_aneb = 1 ;
	  if(dataa_int >= datab_int)
		  tmp_ageb = 1 ;
	
  end

  assign alb = (polar_alb == "INVERT")?~tmp_alb:tmp_alb ;
  assign aeb = (polar_aeb == "INVERT")?~tmp_aeb:tmp_aeb ;
  assign agb = (polar_agb == "INVERT")?~tmp_agb:tmp_agb ;
  assign aleb = (polar_aleb == "INVERT")?~tmp_aleb:tmp_aleb ;
  assign aneb = (polar_aneb == "INVERT")?~tmp_aneb:tmp_aneb ;
  assign ageb = (polar_ageb == "INVERT")?~tmp_ageb:tmp_ageb ;

endmodule // LPM_COMPARE
`ifdef SYNTH
`else
`endcelldefine
`endif
 
